
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Jul 23 07:42:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version KMNG_ATP_TST_main.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/************* Include Files **************************************/
#include "DX_VOS_Stdio.h"
#include "DX_VOS_Utils.h"
#include "DX_VOS_File.h"
#include "MW_ATP_UTIL_funcs.h"
#include "KMNG_Ext_ATP_Acceptance.h"
#include "KMNG_ATP_TST_KeysOp.h"
#include "KMNG_TST_Utils.h"
#include "MW_ATP_define_flags.h"
#include "KMNG_API.h"

/************************ Defines **********************************/
/************************ Enums ************************************/
/************************ Typedefs *********************************/
/************************ Global Data ******************************/
#if KMNG_TST_LOG_ENABLE 
DxVosFile  TST_main_log;
char      *TST_KMNG_log_fname_ptr = DX_NULL;
#endif


/*************** Private function prototype ************************/
void KMNG_ATP_TST_GetVersion( void );
DxError_t KMNG_ExtAPP_ATP_Run_All_ATP_Tests( void );
/************************ Public Functions *************************/

 CRYSError_t KMNG_ExtApp_ATP_menu(void)
 {
    /********* TST Variables Definitions ************/
    DxUint32_t          TST_index = 0;
    DxChar              TST_Var;
    DxStatus            TST_TestStatus = DX_SUCCESS;
    DxError_t           TST_Error = DX_SUCCESS;
    DxBool_t            TST_Endflag = DX_FALSE;    
    
    DxChar* TST_TestsNameStrings[] = 
    {
      "AES Key Import Export",
      "DES Key Import Export",
      "HMAC Key Import Export",
      "RSA Key Import Export",
      "Activate AES key",
      "Activate DES key",
      "Activate HMAC key",
      "Activate RSA key for PRIME operations",
      "Activate RSA key for V15 operations",
      "Activate RSA key for V21 operations"
    };

    
#if _DEBUG
    DX_VOS_DbgPrint_SetPrintFunc(DX_VOS_DebugFilePrint);
#endif

   
    TST_TestStatus = KMNG_Init();
    if(TST_TestStatus != DX_SUCCESS)
    {
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Failed KMNG_Init -Error:%X\n",TST_TestStatus));
		return KMNG_TEST_FAIL;
    }
    
 
    while(1)
    {
      /******** Main Menu - User chooses how to run the tests ********/
      ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"\n-------------- DISCRETIX LTD 2007  ------------\n"));
      KMNG_ATP_TST_GetVersion();
      ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"\n Please enter test number :\n"));
      for (TST_index = 0; TST_index < TST_MAX_NUM_OF_KMNG_Ext_ATP_TESTS; TST_index++)
      {
        ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"[%d] - Run %s\n",TST_index,TST_TestsNameStrings[TST_index]));
      }
      ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"[T] - Run all Acceptance KMNG Tests \n"));
      ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"[Z] - End of Key Management Tests \n"));
      ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"\n------------------------------------------------\n"));
    
      GET_NON_WHITE_SPACE_CHAR(TST_Var);
      
      switch(TST_Var)
      {
        case '0':
          TST_Error = KMNG_ExtApp_ATP_AES_ImportExportSymKeys();
          break;
        case '1':
          TST_Error = KMNG_ExtApp_ATP_DES_ImportExportSymKeys();
          break;
        case '2':
          TST_Error = KMNG_ExtApp_ATP_HMAC_ImportExportSymKeys();
          break;
        case '3':
          TST_Error = KMNG_ExtApp_ATP_RSA_ImportExportSymKeys();
          break;
          
        case '4':
          TST_Error = KMNG_ExtApp_ATP_AES_ActivateKeys();
          break;
          
        case '5':
          TST_Error = KMNG_ExtApp_ATP_DES_ActivateKeys();
          break;          
          
        case '6':
          TST_Error = KMNG_ExtApp_ATP_HMAC_ActivateKeys();
          break;   
          
        case '7':
          TST_Error = KMNG_ExtApp_ATP_RSA_PRIME_ActivateKeys();
          break;
          
        case '8':
          TST_Error = KMNG_ExtApp_ATP_RSA_V15_ActivateKeys();
          break;          
          
        case '9':
          TST_Error = KMNG_ExtApp_ATP_RSA_V21_ActivateKeys();
          break;                    
          
        case 'T':
          TST_Error = KMNG_ExtAPP_ATP_Run_All_ATP_Tests();
          break;  
        
        case 'Z':

          DX_VOS_Printf("\n End of KMNG tests \n");
          TST_Endflag = DX_TRUE;
          break ;
        default:
          ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"User choice is illegal !!\n"));        
          continue;
      }
      if (TST_Endflag == DX_TRUE)
        break;
    
    }
    
    return TST_Error;
 }/* End of KMNG_ATP_TST_main*/

/************************ Private Functions *************************/

 /*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ATP_TST_GetVersion      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  None                                    
 *
 * Description:                                                                 
 *  This function gets the KMNG version and prints it
 *  
 ******************************************************************************/
void KMNG_ExtApp_ATP_TST_GetVersion(void)  
{
  KMNG_Version_t DX_TST_version;

  KMNG_GetVersion(&DX_TST_version);
  KMNG_ATP_TST_PrintVersion(&DX_TST_version);
}

/*****************************************************************************
* Function Name:                                                           
*  KMNG_ATP_TST_Run_All_ATP_Tests      
*  
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:                                                                 
*  This function runs all the tests
*  
******************************************************************************/
DxError_t KMNG_ExtAPP_ATP_Run_All_ATP_Tests( void )
{
    /********* TST Variables Definitions ************/
    DxError_t          TST_Error = DX_SUCCESS, TST_TempError = DX_SUCCESS;
  
    /* Initializing the KMNG in case this function is called w/o the menu
    multiple calls to KMNG_Init are assumed to have no effect.	        */
    TST_Error = KMNG_Init();

    TST_Error = KMNG_TST_PrintCheckErrorReturn(TST_Error,
											   "KMNG_Init",
											   "!!!!!!!!!",
											   "!!!!!!!!!");
    if (TST_Error != DX_SUCCESS)
	    return KMNG_TEST_FAIL;
	

    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******************************************************* \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************** Run All External App KMNG ATP tests ********************** \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******************************************************* \n \n"));

  TST_Error = KMNG_ExtApp_ATP_AES_ImportExportSymKeys();
  
  if (TST_Error == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_AES_ImportExportSymKeys Passed Successfully ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n \n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_AES_ImportExportSymKeys Failed ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******************************************************** \n \n"));
  }

  TST_TempError = TST_TempError + TST_Error;

  TST_Error = KMNG_ExtApp_ATP_DES_ImportExportSymKeys();
  
  if (TST_Error == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*************************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_DES_ImportExportSymKeys Passed Successfully ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*************************************************************** \n \n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_DES_ImportExportSymKeys Failed ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************** \n \n"));
  }

  TST_TempError = TST_TempError + TST_Error;
  
  TST_Error = KMNG_ExtApp_ATP_HMAC_ImportExportSymKeys();
  
  if (TST_Error == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*************************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_HMAC_ImportExportSymKeys Passed Successfully ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*************************************************************** \n \n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_HMAC_ImportExportSymKeys Failed ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************** \n \n"));
  }

  TST_TempError = TST_TempError + TST_Error;

  TST_Error = KMNG_ExtApp_ATP_RSA_ImportExportSymKeys();
  
  if (TST_Error == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_RSA_ImportExportSymKeys Passed Successfully ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************************** \n \n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_RSA_ImportExportSymKeys Failed ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************** \n \n"));
  }

  TST_TempError = TST_TempError + TST_Error;

  TST_Error = KMNG_ExtApp_ATP_AES_ActivateKeys();
  
  if (TST_Error == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_AES_ActivateKeys Passed Successfully ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n \n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_AES_ActivateKeys Failed ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n \n"));
  }

  TST_TempError = TST_TempError + TST_Error;
  
  TST_Error = KMNG_ExtApp_ATP_DES_ActivateKeys();
  
  if (TST_Error == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_DES_ActivateKeys Passed Successfully ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n \n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_DES_ActivateKeys Failed ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n \n"));
  }

  TST_TempError = TST_TempError + TST_Error;
  
  TST_Error = KMNG_ExtApp_ATP_HMAC_ActivateKeys();
  
  if (TST_Error == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_HMAC_ActivateKeys Passed Successfully ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n \n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_HMAC_ActivateKeys Failed ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n \n"));
  }

  TST_TempError = TST_TempError + TST_Error;
  
  TST_Error = KMNG_ExtApp_ATP_RSA_PRIME_ActivateKeys();
  
  if (TST_Error == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_RSA_PRIME_ActivateKeys Passed Successfully ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n \n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_RSA_PRIME_ActivateKeys Failed ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n \n"));
  }

  TST_TempError = TST_TempError + TST_Error;
  
  TST_Error = KMNG_ExtApp_ATP_RSA_V15_ActivateKeys();
  
  if (TST_Error == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_RSA_V15_ActivateKeys Passed Successfully ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n \n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_RSA_V15_ActivateKeys Failed ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n \n"));
  }

  TST_TempError = TST_TempError + TST_Error;
  
  TST_Error = KMNG_ExtApp_ATP_RSA_V21_ActivateKeys();
  
  if (TST_Error == DX_SUCCESS)
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_RSA_V21_ActivateKeys Passed Successfully ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************************************************************************ \n \n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"******** KMNG_ExtApp_ATP_RSA_V21_ActivateKeys Failed ******* \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*********************************************************** \n \n"));
  }
  
  /*Check if all tests pass*/
    if (TST_TempError != DX_SUCCESS)
	{
        ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE KMNG TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
	}
	else
	{
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"\n \n**********************\n"));
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"**********************\n"));
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"*** ALL OF THE EXT SEP APPLICATION KMNG Acceptance TESTS PASS   :-)         ***\n"));
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"**********************\n"));
		ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"**********************\n"));
	}


  return TST_TempError;
}
